package gov.va.vamf.scheduling.direct.resource;



import com.agilex.healthcare.veteranappointment.domain.VeteranAppointmentConfiguration;
import com.agilex.healthcare.veteranappointment.dataservice.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;


import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Component
@Path("/configurations")
@Scope("request")
public class ConfigurationResource {

    @Resource
    ConfigurationService configService;

    @GET
    @Produces({ "application/json" })
    @Path("/")
    public VeteranAppointmentConfiguration getConfigurations() {
        return configService.getConfigurations();
    }


}
